<?php

/*
+--------------------------------------------------------------------------
|   Invision Power Board v1.2
|   ========================================
|   by Matthew Mecham
|   (c) 2001 - 2003 Invision Power Services
|   http://www.invisionpower.com
|   ========================================
|   Web: http://www.invisionboard.com
|   Email: matt@invisionpower.com
|   Licence Info: http://www.invisionboard.com/?license
+---------------------------------------------------------------------------
|
|   > Show all the members
|   > Module written by Matt Mecham
|   > Date started: 20th February 2002
|
|	> Module Version Number: 1.0.0
+--------------------------------------------------------------------------
*/


$idx = new Memberlist;

class Memberlist {

    var $output     = "";
    var $page_title = "";
    var $nav        = array();
    var $html       = "";
    var $base_url   = "";

    var $first       = 0;
    var $max_results = 10;
//|Chack - change default sort order
    var $sort_key    = 'posts';
    var $sort_order  = 'desc';
    var $filter2      = 'ALL';
//|Chack
    var $filter      = 'ALL';

    var $mem_titles = array();
    var $mem_groups = array();


    function Memberlist()
    {
    	global $ibforums, $DB, $std, $print;


    	if ($ibforums->input['CODE'] == "") $ibforums->input['CODE'] = 'listall';

    	//--------------------------------------------
    	// Require the HTML and language modules
    	//--------------------------------------------

		$ibforums->lang = $std->load_words($ibforums->lang, 'lang_mlist', $ibforums->lang_id );

    	$this->html = $std->load_template('skin_mlist');

    	$this->base_url        = $ibforums->base_url;

    	if ($ibforums->member['g_mem_info'] != 1)
 		{
 			$std->Error( array( 'LEVEL' => 1, 'MSG' => 'no_permission' ) );
    	}

    	$see_groups = array();

    	//--------------------------------------------
    	// Get the member groups, member titles stuff
    	//--------------------------------------------
    	
//|Chack - add g_prefix, g_surfix
    	$DB->query("SELECT g_title, g_id, g_icon, prefix, suffix from ibf_groups WHERE g_hide_from_list <> 1 ORDER BY g_title");
    	
    	while ($row = $DB->fetch_row() )
    	{
    		$see_groups[] = $row['g_id'];
    		
    		$this->mem_groups[ $row['g_id'] ] = array( 'TITLE'  => $row['g_title'],
    												   'ICON'   => $row['g_icon'],
    												   'PREFIX'   => $row['prefix'],
    												   'SUFFIX'   => $row['suffix'],
    											     );
    	}
//|Chack

    	unset($row);

    	$group_string = implode( ",", $see_groups );

    	$DB->free_result();

    	$DB->query("SELECT title, id, posts, pips from ibf_titles ORDER BY posts DESC");

    	while ($row = $DB->fetch_row() )
    	{
    		$this->mem_titles[ $row['id'] ] = array( 'TITLE'   => $row['title'],
    												 'POSTS'   => $row['posts'],
    												 'PIPS'    => $row['pips'],

    											   );
    	}

    	unset($row);

    	$DB->free_result();

    	$the_filter  = array( 'ALL' => $ibforums->lang['show_all'] );

    	foreach($this->mem_groups as $id => $data)
    	{
    		if ($id == $ibforums->vars['guest_group'])
    		{
    			continue;
    		}
    		$the_filter[$id] = $data['TITLE'];
    	}

    	//------------------------------------------
    	// Test for input
    	//------------------------------------------

    	if (isset($ibforums->input['st']))          $this->first       = $ibforums->input['st'];
    	if (isset($ibforums->input['max_results'])) $this->max_results = $ibforums->input['max_results'];
    	if (isset($ibforums->input['sort_key']))    $this->sort_key    = $ibforums->input['sort_key'];
    	if (isset($ibforums->input['sort_order']))  $this->sort_order  = $ibforums->input['sort_order'];
    	if (isset($ibforums->input['filter']))      $this->filter      = $ibforums->input['filter'];

    	//------------------------------------------
    	// Fix up the search box
    	//------------------------------------------

    	$ibforums->input['name'] = $std->clean_value(trim(urldecode(stripslashes($ibforums->input['name']))));

    	if ($ibforums->input['name'] == "")
    	{
    		$ibforums->input['name_box'] = 'all';
    	}

    	//------------------------------------------
    	// Init some arrays
    	//------------------------------------------

    	$the_sort_key = array( 'name'          => 'sort_by_name',
    	                                           'money'   => 'sort_by_money', /*hack*/
    						   'posts'         => 'sort_by_posts',
    						   'user_regdate'  => 'sort_by_joined',         
    						   'last_activity'  => 'sort_by_last_activity', /*|Chack*/
    						   'last_post'  => 'sort_by_last_post',         /*|Chack*/
    						   'mgroup'  => 'sort_by_mgroup',               /*|Chack*/
    						   'location'  => 'sort_by_location',           /*|Chack*/
    						 );

    	$the_max_results = array( 10  => '10',
    							  20  => '20',
    							  30  => '30',
    							  40  => '40',
    							  50  => '50',
    						    );

    	$the_sort_order = array(  'desc' => 'descending_order',
    							  'asc'  => 'ascending_order',
    						   );

    	//------------------------------------------
    	// Start the form stuff
    	//------------------------------------------

    	$filter_html      = "<select name='filter' class='forminput'>\n";
    	$sort_key_html    = "<select name='sort_key' class='forminput'>\n";
    	$max_results_html = "<select name='max_results' class='forminput'>\n";
    	$sort_order_html  = "<select name='sort_order' class='forminput'>\n";

    	foreach ($the_sort_order as $k => $v) {
			$sort_order_html .= $k == $this->sort_order ? "<option value='$k' selected>" . $ibforums->lang[ $the_sort_order[ $k ] ] . "</option>\n"
											            : "<option value='$k'>"          . $ibforums->lang[ $the_sort_order[ $k ] ] . "</option>\n";
		}
     	foreach ($the_filter as $k => $v) {
			$filter_html .= $k == $this->filter  ? "<option value='$k' selected>"         . $the_filter[ $k ] . "</option>\n"
											            : "<option value='$k'>"          . $the_filter[ $k ] . "</option>\n";
		}
    	foreach ($the_sort_key as $k => $v) {
			$sort_key_html .= $k == $this->sort_key ? "<option value='$k' selected>"     . $ibforums->lang[ $the_sort_key[ $k ] ] . "</option>\n"
											            : "<option value='$k'>"          . $ibforums->lang[ $the_sort_key[ $k ] ] . "</option>\n";
		}
    	foreach ($the_max_results as $k => $v) {
			$max_results_html .= $k == $this->max_results ? "<option value='$k' selected>". $the_max_results[ $k ] . "</option>\n"
											            : "<option value='$k'>"          . $the_max_results[ $k ] . "</option>\n";
		}

		$ibforums->lang['sorting_text'] = preg_replace( "/<#FILTER#>/"      , $filter_html."</select>"     , $ibforums->lang['sorting_text'] );
    	$ibforums->lang['sorting_text'] = preg_replace( "/<#SORT_KEY#>/"    , $sort_key_html."</select>"   , $ibforums->lang['sorting_text'] );
    	$ibforums->lang['sorting_text'] = preg_replace( "/<#SORT_ORDER#>/"  , $sort_order_html."</select>" , $ibforums->lang['sorting_text'] );
    	$ibforums->lang['sorting_text'] = preg_replace( "/<#MAX_RESULTS#>/" , $max_results_html."</select>", $ibforums->lang['sorting_text'] );

    	$error = 0;

    	if (! isset($the_sort_key[ $this->sort_key ]) )       $error = 1;
    	if (! isset($the_sort_order[ $this->sort_order ]) )   $error = 1;
    	if (! isset($the_filter[ $this->filter ]) )           $error = 1;
    	if (! isset($the_max_results[ $this->max_results ]) ) $error = 1;

    	if ($error == 1 )
    	{
    		if ( $ibforums->input['b'] == 1 )
    		{
    			$std->Error( array( LEVEL=> 1, MSG =>'ml_error') );
    		}
    		else
    		{
    		$std->Error( array( LEVEL=> 5, MSG =>'incorrect_use') );
    	}
    	}

    	//---------------------------------------------
    	// Find out how many members match our criteria
    	//---------------------------------------------

    	$q_extra = "";

    	if ($this->filter != 'ALL')
    	{
    		// Are we allowed to see this group?

    		if ( ! preg_match( "/(^|,)".$this->filter."(,|$)/", $group_string ) )
    		{
    			$q_extra = " AND m.mgroup IN($group_string)";
    		}
    		else
    		{
    			$q_extra = " AND m.mgroup='".$this->filter."' ";
    		}
    	}

    	if ($ibforums->input['name_box'] != 'all')
    	{
    		if ( $ibforums->input['name_box'] == 'begins' )
    		{
    			$q_extra .= " AND m.uname LIKE '".$ibforums->input['name']."%'";
    		}
//|Chack - fixed member name search
			elseif ($ibforums->input['name_box'] == 'match')
			{
    			$q_extra .= " AND m.uname = '".$ibforums->input['name']."'";
			}
//|Chack
    		else
    		{
    			$q_extra .= " AND m.uname LIKE '%".$ibforums->input['name']."%'";
    		}
    	}

//|Chack- add homepage only checkbox
    	if ($ibforums->input['homepageonly'] == 1)
    	{
    		$q_extra .= " AND (m.url <> '' and m.url <> 'http://')";
    	}
//|Chack
    	if ($ibforums->input['photoonly'] == 1)
    	{
    		$DB->query("SELECT COUNT(m.uid) as total_members FROM ibf_members m LEFT JOIN ibf_member_extra me ON me.id=m.uid WHERE me.photo_location <> '' AND m.uid > 0".$q_extra);

    		$q_extra .= " AND me.photo_location <> ''";
    	}
    	else
    	{
	    	$DB->query("SELECT COUNT(m.uid) as total_members FROM ibf_members m WHERE m.uid > 0".$q_extra);
	    }

		$max = $DB->fetch_row();

		$DB->free_result();

		$links = $std->build_pagelinks(  array( 'TOTAL_POSS'  => $max['total_members'],
												'PER_PAGE'    => $this->max_results,
												'CUR_ST_VAL'  => $this->first,
												'L_SINGLE'     => "",
												'L_MULTI'      => $ibforums->lang['pages'],
												'BASE_URL'     => $this->base_url."&amp;act=Members&amp;photoonly={$ibforums->input['photoonly']}&amp;name=".urlencode($ibforums->input['name'])."&amp;name_box={$ibforums->input['name_box']}&amp;max_results={$this->max_results}&amp;filter={$this->filter}&amp;sort_order={$this->sort_order}&amp;sort_key={$this->sort_key}"
											  )
									   );

		$this->output = $this->html->start();

		$this->output .= $this->html->Page_header( array( 'SHOW_PAGES' => $links) );

		//-----------------------------
		// START THE LISTING
		//m.money, m.kernel_posts, m.delete_posts,hack
		//-----------------------------

//|Chack - modify to main sql string
		$cut_off = ($ibforums->vars['au_cutoff'] != "") ? $ibforums->vars['au_cutoff'] * 60 : 900;
		$t_time = time() - $cut_off;

		$DB->query("SELECT DISTINCT m.uname, m.uid, m.posts, m.money, m.kernel_posts, m.delete_posts, m.user_regdate, m.mgroup, m.email,m.title, m.user_viewemail, m.user_from, m.user_aim, m.user_icq,  m.user_yim , m.user_msnm , m.user_avatar, m.view_avs, m.last_post, m.last_activity, m.url ,
		                   s.sess_id as on_offline, s.login_type as is_privacy,
		                   mo.member_id as is_moderator,
		                   me.photo_location, me.photo_type, me.photo_dimensions
				    FROM ibf_members m
				      LEFT JOIN xoops_session s ON s.member_id=m.uid and s.sess_updated  > '".$t_time."'
				      LEFT JOIN ibf_moderators mo ON mo.member_id=m.uid
				      LEFT JOIN ibf_member_extra me ON me.id=m.uid
				      LEFT JOIN ibf_groups g ON m.mgroup=g.g_id
				    WHERE m.uid > 0".$q_extra." AND g.g_hide_from_list <> 1
				    ORDER BY m.".$this->sort_key." ".$this->sort_order.", m.uid ASC
				    LIMIT ".$this->first.",".$this->max_results);

		$icon_pm = "<img src='".$ibforums->vars['img_url']."/p_pm_s.gif' border='0' />";
		$icon_email = "<img src='".$ibforums->vars['img_url']."/p_email_s.gif' border='0' />";
		$icon_icq = "<img src='".$ibforums->vars['img_url']."/p_icq_s.gif' border='0' />";
		$icon_yim = "<img src='".$ibforums->vars['img_url']."/p_yim_s.gif' border='0' />";
		$icon_msn = "<img src='".$ibforums->vars['img_url']."/p_msn_s.gif' border='0' />";
		$icon_addresscard = "<img src='".$ibforums->vars['img_url']."/addresscard.gif' border='0' />";
		$icon_www = "<img src='".$ibforums->vars['img_url']."/p_www_s.gif' border='0' />";

		$add_contact = "<img src='".$ibforums->vars['img_url']."/add.gif' border='0' />";
		$camera_s = "<img src='".$ibforums->vars['img_url']."/camera_s.gif' border='0' />";
		$noavatar_s = "<img src='".$ibforums->vars['img_url']."/noavatar_s.gif' border='0' alt='No Avatar' />";

		$icon_online = "<img src='".$ibforums->vars['img_url']."/icon_online.gif' border='0' alt='".$ibforums->lang['tooltip_online']."' />";
		$icon_online_hide = "<img src='".$ibforums->vars['img_url']."/icon_online_hide.gif' border='0' alt='".$ibforums->lang['tooltip_online_hide']."' />";
		$icon_offline = "<img src='".$ibforums->vars['img_url']."/icon_offline.gif' border='0' alt='".$ibforums->lang['tooltip_offline']."' />";
//|Chack

		while($member = $DB->fetch_row() )
		{

			$pips = 0;

			foreach($this->mem_titles as $k => $v)
			{
				if ($member['posts'] >= $v['POSTS'])
				{
					if (!$member['title'])
					{
						$member['title'] = $this->mem_titles[ $k ]['TITLE'];
					}
					$pips = $v['PIPS'];
					break;
				}
			}

			if ($this->mem_groups[ $member['mgroup'] ]['ICON'])
			{
				$member['pips'] = "<img src='{$ibforums->vars[TEAM_ICON_URL]}/{$this->mem_groups[ $member['mgroup'] ][ICON]}' border='0' />";
			}
			else
			{
				if ($pips)
				{
					if (preg_match( "/^\d+$/", $pips ) )
					{
						for ($i = 1; $i <= $pips; ++$i)
						{
							$member['pips'] .= "<{A_STAR}>";
						}
					}
					else
					{
						$member['pips'] = "<img src='{$ibforums->vars[TEAM_ICON_URL]}/$pips' border='0' />";
					}
				}
			}
//|Chack- add/modify below section
//Skin convert
			$member['name']   = $member['uname'];
			$member['id']     = $member['uid'];
//
			$joined_days = number_format(((time() - $member['joined'])/3600/24), 0, '', '');
			$joined_days = $joined_days < 1 ? 1 : $joined_days;
			$lastactive_days = number_format(((time() - $member['last_activity'])/3600/24), 0, '', '');

			$tooltip_contact = str_replace("<#member_name#>", $member['name'], $ibforums->lang['tooltip_contact']);
			$tooltip_add_contact = str_replace("<#member_name#>", $member['name'], $ibforums->lang['tooltip_add_contact']);
			$tooltip_addresscard = str_replace("<#member_name#>", $member['name'], $ibforums->lang['tooltip_addresscard']);
			$tooltip_homepage = str_replace("<#member_name#>", $member['name'], $ibforums->lang['tooltip_homepage']);

	//### add tooltip to show member alive days
			$member['tooltip_alive'] = str_replace("<#member_name#>", $member['uname'], sprintf($ibforums->lang['tooltip_alive'], $joined_days, $lastactive_days));

			$member['joined'] = $std->get_date( $member['user_regdate'], 'JOINED' );
			
			$member['group']  = $this->mem_groups[ $member['mgroup'] ]['TITLE'];

	//### add tooltip to email icon
			if (!$member['user_viewemail'])
			{
				$member['member_email'] = "<a href='{$this->base_url}act=Mail&amp;CODE=00&amp;MID={$member['uid']}' title='".sprintf($tooltip_contact, "qll")."'>{$icon_email}</a>";
			}
			else
			{
				$member['member_email'] = '';
			}
			
	//### add tooltip to icq icon
			if ($member['user_icq'])
			{
				$member['icq_number'] = "<a href=\"javascript:PopUp('{$this->base_url}act=ICQ&amp;MID={$member['uid']}','Pager','450','330','0','1','1','1')\" title='".sprintf($tooltip_contact, "ICQ")."'>{$icon_icq}</a>";
			}
			else
			{
				$member['icq_number'] = '';
			}

	//### add member name prefix & suffix
			$member['uname'] = "<a href=\"{$ibforums->base_url}showuser={$member['uid']}\">{$this->mem_groups[ $member['mgroup'] ]['PREFIX']}{$member['name']}{$this->mem_groups[ $member['mgroup'] ]['SUFFIX']}</a>";

	//### add PM icon
			$member['message_icon'] = "<a href='{$this->base_url}act=Msg&amp;CODE=04&amp;MID={$member['uid']}' title='".sprintf($tooltip_contact, "PM")."'>{$icon_pm}</a>";
			$member['add_contact_icon'] = "<a href='{$this->base_url}act=Msg&amp;CODE=02&amp;MID={$member['uid']}' title='{$tooltip_add_contact}'>{$add_contact}</a>";

	//### add Yahoo icon
			if ($member['user_yim'])
			{
				$member['yahoo_icon'] = "<a href=\"javascript:PopUp('{$this->base_url}act=YAHOO&amp;MID={$member['uid']}','Pager','450','330','0','1','1','1')\" title='".sprintf($tooltip_contact, "YahooYɳq")."'>{$icon_yim}</a>";
			}
			else
			{
				$member['yahoo_icon'] = '';
			}

	//### add MSN icon
			if ($member['user_msnm'])
			{
				$member['msnname'] = "<a href=\"javascript:PopUp('{$this->base_url}act=MSN&amp;MID={$member['uid']}','Pager','450','330','0','1','1','1')\" title='".sprintf($tooltip_contact, "MSN Messenger")."'>{$icon_msn}</a>";
			}
			else
			{
				$member['msnname'] = '';
			}

	//### add addresscard & Homepage icon
			$member['addresscard'] = "<a href=\"javascript:PopUp('{$this->base_url}act=Profile&amp;CODE=showcard&amp;MID={$member['uid']}','AddressCard','470','300','0','1','1','1')\" title='{$tooltip_addresscard}'>{$icon_addresscard}</a>";

			if ($member['url'] and preg_match("/^http:\/\/\S+$/", $member['url']))
		   	{
				$member['homepage'] = "<a href='{$member['url']}' target='_blank' title='{$tooltip_homepage}'>{$icon_www}</a>";
			}
			else
			{
				$member['homepage'] = '';
			}

	//### add online-offline icon
			if ($member['on_offline'])
			{
				if ($member['is_privacy'] == 1)
				{
					$member['on_offline'] = (($ibforums->member['mgroup'] == $ibforums->vars['admin_group']) and ($ibforums->vars['disable_admin_anon'] != 1)) ? "{$icon_online_hide}" : "{$icon_offline}";
				}
				else
				{
					$member['on_offline'] = "{$icon_online}";
				}
			}
			else
			{
				$member['on_offline'] = "{$icon_offline}";
			}

	//### do something if a Administrator or Moderator
			if ($member['mgroup'] == $ibforums->vars['admin_group'])
			{
				$member['is_moderator'] = $ibforums->lang['is_administrator'];
			}
			else
			{
				$member['is_moderator'] = ($member['is_moderator']) ? $ibforums->lang['is_moderator'] : $ibforums->lang['is_member'];
			}


	//### show user's small avatar
			//$member['user_avatar'] = $std->get_avatar( $member['user_avatar'], $member['view_avs'], $member['avatar_size'] );

		//### set avatar dimension limit (width or height)
			$limit_dims = "width";
		//### set avatar size limit (a integar number)
			$limit_size = 48;

			if (!$ibforums->vars['avatars_on'])
			{
				$member['user_avatar'] = "::";
			}
			else if (!$member['user_avatar'] or (preg_match("/^noavatar/", $member['user_avatar'])))
			{
				$member['user_avatar'] = "{$noavatar_s}";
			}
			else if ($member['view_avs'] == 0 or (preg_match( "/\.swf/", $member['user_avatar'])))
			{
				$member['user_avatar'] = "{$noavatar_s}";
			}
			else if (preg_match( "/^http:\/\//", $member['user_avatar']))
			{
				$member['user_avatar'] = "<img src='{$member['user_avatar']}' border='0' {$limit_dims}='{$limit_size}' alt='' />";
			}
			else if (($ibforums->vars['avup_size_max'] > 1) and (preg_match("/^upload:av-(?:\d+)\.(?:\S+)/", $member['user_avatar'])))
			{
				$member['user_avatar'] = preg_replace("/^upload:/", "", $member['user_avatar']);
				$member['user_avatar'] = "<img src='{$ibforums->vars['upload_url']}/{$member['user_avatar']}' border='0' {$limit_dims}='{$limit_size}' alt='' />";
			}
			else if ($member['user_avatar'] != "")
			{
				$member['user_avatar'] = "<img src='{$ibforums->vars['AVATARS_URL']}/{$member['user_avatar']}' border='0' {$limit_dims}='{$limit_size}' alt='' />";
			}
			else
			{
				$member['user_avatar'] = "&nbsp;";
			}

	//### get member's last activity date
			$member['last_activity'] = $std->get_date( $member['last_activity'], 'JOINED' );
			$member['tooltip_location'] = $member['location'] ? $ibforums->lang['tooltip_location'].$member['location'] : "";

	//### get member's last ten posts link
			$member['last_post_date'] = $std->get_date( $member['last_post'], 'JOINED' );
			$member['last_post_short'] = $std->get_date( $member['last_post'], 'SHORT' );

			if ($member['last_post'])
			{
			//# how to get member's lastpost link ??
			$member['last_ten'] = "<img src='".$ibforums->vars['img_url']."/newpost.gif' border='0' /> <a href='{$ibforums->base_url}act=Search&amp;CODE=getalluser&amp;mid={$member['uid']}' title='{$ibforums->lang['tooltip_lastpost']}{$member['last_post_short']}{$ibforums->lang['tooltip_getalluser']}'>{$member['last_post_date']}</a>";
			}

	$count++;
//|Chack
			if ($member['photo_type'] and $member['photo_location'])
			{
				$member['camera'] = "<a href=\"javascript:PopUp('{$this->base_url}act=Profile&amp;CODE=showphoto&amp;MID={$member['uid']}','Photo','200','250','0','1','1','1')\"><{CAMERA}></a>";
			}

			$member['password'] = "";

			$member['posts'] = $std->do_number_format($member['posts']);

			$this->output .= $this->html->show_row($member);

		}

//|Chack - modified Page_end output
		$page_end['total_shown'] = $max['total_members'] ? sprintf($ibforums->lang['page_end_message'], $max['total_members'], $count) : $ibforums->lang['page_end_nofound'];
		$page_end['checked_photoonly'] = $ibforums->input['photoonly'] == 1 ? 'checked="checked"' : "";
		$page_end['checked_homepageonly'] = $ibforums->input['homepageonly'] == 1 ? 'checked="checked"' : "";

	//|Chack 2 - fixed member name search
		if ( $ibforums->input["name_box"] == "all" )
		{
			$ibforums->input['name'] = "";
			$sel_all = " selected";
		}
		$sel_begins = ($ibforums->input["name_box"] == "begins") ? " selected" : "";
		$sel_contains = ($ibforums->input["name_box"] == "contains") ? " selected" : "";
		$sel_match = ($ibforums->input["name_box"] == "match") ? " selected" : "";

		$page_end['name_box_options'] = "
			<option value='all' {$sel_all}>{$ibforums->lang['ch_all']}</option>
			<option value='match'{$sel_match}>{$ibforums->lang['ch_match']}</option>
			<option value='begins'{$sel_begins}>{$ibforums->lang['ch_begins']}</option>
			<option value='contains'{$sel_contains}>{$ibforums->lang['ch_contains']}</option>";

	//### simple board stats, copy from Board.php
			$DB->query("SELECT * FROM ibf_stats");
			$stats = $DB->fetch_row();
			
			$total_posts = $stats['TOTAL_REPLIES'] + $stats['TOTAL_TOPICS'];
			
			$total_posts        = $std->do_number_format($total_posts);
			$stats['MEM_COUNT'] = $std->do_number_format($stats['MEM_COUNT']);
			
			$link = $ibforums->base_url."showuser=".$stats['LAST_MEM_ID'];
			
			$ibforums->lang['total_word_string'] = str_replace( "<#posts#>" , "$total_posts"          , $ibforums->lang['total_word_string'] );
			$ibforums->lang['total_word_string'] = str_replace( "<#reg#>"   , $stats['MEM_COUNT']     , $ibforums->lang['total_word_string'] );
			$ibforums->lang['total_word_string'] = str_replace( "<#mem#>"   , $stats['LAST_MEM_NAME'] , $ibforums->lang['total_word_string'] );
			$ibforums->lang['total_word_string'] = str_replace( "<#link#>"  , $link                   , $ibforums->lang['total_word_string'] );
			
		$page_end['show_stats'] = $ibforums->lang['total_word_string'];


		$this->output .= $this->html->Page_end( $page_end );
//|Chack

		$this->output .= $this->html->end( array( 'SHOW_PAGES' => $links) );

    	$print->add_output("$this->output");
        $print->do_output( array( 'TITLE' => $ibforums->lang['page_title'], 'JS' => 0, NAV => array( $ibforums->lang['page_title'] ) ) );

 	}



}

?>
